/*
 *  Copyright 2004 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 */
/*
 *  ======== mcbsp_loopback.cmd ========
 *
 */

/* byte addressing */
-c
-sysstack 0x600   /*0x280 to 0x480*/
-stack  0x600     /* SOFTWARE STACK SIZE           *//*0x500 to 0x700*/
/*-heap   0x8000                        HEAP AREA SIZE       1762>>1*2+108+480      0x1170+0x2E68(11880)   */ 
-heap   0x1000 /*-heap 0x6400 is ok in QCIF */


MEMORY 
{

   DARAM_Idct_Buffer_Block:                  origin = 0x100,       len=0x110
   DARAM_Pixel_Interpolation_Buffer_Block:   origin = 0x220,       len=0xDC8
   DARAM_Internal_Ref_Macroblock:            origin = 0xFE8,       len=0x4800
   DARAM_Interrupt_Vector:                   origin = 0x5800,      len=0x200
   DARAM:                                    origin = 0x5A00,      len = 0x1A000
   
   SARAM_Clip_Table:                         origin = 0x20000,     len=0x800
   SARAM_Internal_Cur_Macroblock:            origin = 0x20800,     len=0x1200  /*0x900 for internal_cur size 6*/
   SARAM_MB_buffer:                          origin = 0x21A00,     len=0x5910  /* 114*2(word)*5*20=0x5910 for QVGA*/
   SARAM_Bitstream_Internal:                 origin = 0x27310,     len=0xCF0   /*0xCF0=3312*/

   SDRAM_Text:                               origin = 0x080000,    len = 0x13000

   /* SARAM_idct_iclip:                      origin = 0x24800,     len=0x800 */ 
   /* SARAM_Bitstream_Internal:              origin = 0x24400,     len=0xC00 */
}

SECTIONS
{

     block_SECTION       > DARAM_Idct_Buffer_Block
     interBuffer_SECTION > DARAM_Idct_Buffer_Block

     .vectors: {} > DARAM_Interrupt_Vector	
     .sysstack {} > DARAM
     .stack:   {} > DARAM
     .sysmem:  {} > DARAM
     .bss:     {} > DARAM

     .const:   {} > DARAM
     .cio:     {} > DARAM
     .cinit:   {} > DARAM

     .switch:  {} > DARAM 

     mem_transfer_clip_table_SECTION > SARAM_Clip_Table
     /*iclip_SECTION > SARAM_idct_iclip*/
     .text:    {} > SDRAM_Text
}